<?php get_header(); ?>
<div class="homepage-banner">
    <?php
    // Retrieve the image ID from ACF custom field
    $image_id = get_field('homepage_banner_image'); // Replace 'homepage_banner_image' with your actual ACF field name
    if ($image_id) :
        // Get the full-size image URL
        $image_url = wp_get_attachment_image_url( $image_id, 'full' );

        // Get the alt text for the image
        $alt_text = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
        ?>
        <img 
            src="<?php echo esc_url( $image_url ); ?>" <!-- Default image for browsers without srcset support -->
            srcset="
                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-small' ) ); ?> 320w,
                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-medium' ) ); ?> 640w,
                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-large' ) ); ?> 1280w,
                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-xlarge' ) ); ?> 1920w,
                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-xxlarge' ) ); ?> 2560w,
                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-4k' ) ); ?> 3840w
            "
            sizes="
                (max-width: 480px) 320px,   /* Mobile */
                (max-width: 768px) 640px,   /* Tablet */
                (max-width: 1280px) 1280px, /* Desktop */
                (max-width: 1920px) 1200px, /* Larger desktop */
                1600px                      /* For larger/4K displays */
            "
            alt="<?php echo esc_attr( $alt_text ); ?>"  <!-- Alt text for the image -->
            loading="lazy"
            decoding="async"
        />
    <?php endif; ?>
</div>

<?php get_footer(); ?>
