$(window).load(function(){
    
    $("#vi-banner-carousel").slick({
      dots: false,
      infinite: false,
      slidesToShow: 6,
      slidesToScroll: 1,
      arrows: true,
      useTransform: true,
      speed: 300,
      waitForAnimate: true,
      draggable: false,
      swipe: false,
      swipeToSlide: false,
      touchMove: false,
      touchThreshold: 8,
      prevArrow: "<a href='#' class='slick-prev slick-arrow'><img src='http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/NavArrow_LEFT.png'/></a>",
      nextArrow: "<a href='#' class='slick-next slick-arrow'><img src='http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/NavArrow_RIGHT.png'/></a>"

    });

    // Alt image slider setting
    var filenameByStyle = [
      'http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/072116_US_DenimVI_W_Banner_rockstar_0',
      'http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/072116_US_DenimVI_W_Banner_curvy_0',
      'http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/072116_US_DenimVI_W_Banner_original_0',
      'http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/072116_US_DenimVI_W_Banner_skinny_0',
      'http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/072116_US_DenimVI_W_Banner_jegging_0',
      'http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/072116_US_DenimVI_W_Banner_straight_0',
      'http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/072116_US_DenimVI_W_Banner_boyfriend_0',
      'http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/072116_US_DenimVI_W_Banner_boot_0',
      'http://oldnavy.gap.com/Asset_Archive/ONWeb/content/0011/972/401/assets/images/072116_US_DenimVI_W_Banner_flare_0'
    ];
    var imageFileExtension = ".jpg";
    var altSlidesToShow = 3;
    var altSliderSpeed = 300;
    var altSliderAutoplaySpeed = 2000;


    var fitUnitsCount = 0;
    $('ul#vi-banner-carousel li.fit-unit').each(function(){
        fitUnitsCount += $(this).length;
    });

    var slidesToShow = ($('#vi-banner-carousel').get(0).slick.options.slidesToShow);

    var toggleStatusForTracking;

    // duplicate slick-initialized class to hide broken pre-load images
    $('ul#vi-banner-carousel.slick-slider.slick-initialized').closest('.slider-container').addClass('slick-initialized');

    // adding index & boolean data attr to activated units
    $('ul#vi-banner-carousel li.fit-unit').attr('data-activated-unit', true);
    $('ul#vi-banner-carousel li.fit-details').attr('data-activated-unit', false);
    

    // adding data attr for visible units on viewport
    $('ul#vi-banner-carousel li.fit-unit').slice(0,slidesToShow).attr('data-visible-onviewport', true);

    // adding IDs to end of fit & details units
    $('ul#vi-banner-carousel li.fit-unit').last().attr('id', 'end-fit-unit');
    $('ul#vi-banner-carousel li.fit-details').last().attr('id', 'end-fit-details');

    // adding indexes to each fit-unit
    $('ul#vi-banner-carousel li.fit-unit').each(function(index){
      $(this).attr('data-fit-unit-index', index);
    });
    $('ul#vi-banner-carousel li.fit-details').each(function(index){
      $(this).attr('data-fit-unit-index', index);
    });
    // adding IDs to each toggle buttons
    $('ul#vi-banner-carousel li.fit-unit span a').each(function(index){
      $(this).attr('id', 'toggle-point-' + index);
    });


    // detect end unit of the viewport
    detectFirstUnitLastUnit();
    detectEndUnitOnViewport();
    changeAnimationSpeedOnToggleButton();

    // Enable & Disable arrow buttons
    setTimeout(excuteDisEnableArrowButtons(), 200);
   
    // declare function for finding & get total of 'data-activated-unit'
    function findActivatedUnits(){

      var totalOfActivatedUnits = 0;

      $('ul#vi-banner-carousel li[data-activated-unit="true"]').each(function(){
        totalOfActivatedUnits += $(this).length;
      });

      // console.log('function running : totalOfActivatedUnits ', totalOfActivatedUnits);
    };


    function toggleButton_expandCollapseFunc(that){
      var widthOfUnit = $('.fit-unit .fit-image-wrapper img').width();

      var fitImageContainerIndex = that.closest('li.fit-unit').data('slick-index');
      var fitDetailsContainerIndex = fitImageContainerIndex + 1;

      var fitImageContainer = $("#vi-banner-carousel").find("[data-slick-index='" + fitImageContainerIndex + "']");
      var fitDetailsContainer = $("#vi-banner-carousel").find("[data-slick-index='" + fitDetailsContainerIndex + "']");

      that.toggleClass("expanded");

      // collapse in
      if ($(fitDetailsContainer).hasClass('collapsed')) {
        
        $(fitDetailsContainer).removeClass('collapsed').addClass('expanded');
        $(fitDetailsContainer).css({ 'left':'0px'});

        $(fitDetailsContainer).css({ 'width':widthOfUnit });
        $('.fit-detail-wrapper img').css({ 'width':widthOfUnit });

        // data attr 'true' as activated unit
        $(fitDetailsContainer).attr('data-activated-unit', true);

        // move expand button to the right
        $(fitImageContainer).find('span').css({ 'transform' : 'translateX('+ widthOfUnit +'px)' });
      }

      // expand out
      else{
        
        $(fitDetailsContainer).removeClass('expanded').addClass('collapsed');
        $(fitDetailsContainer).css({ 'left':-widthOfUnit });
        $(fitDetailsContainer).css({ 'width':'0px' });

        // data attr 'true' as activated unit
        $(fitDetailsContainer).attr('data-activated-unit', false);

        // move expand button to the left
        $(fitImageContainer).find('span').css({ 'transform' : 'translateX(0)' });

      }
    };


    var tempIndex = 0;

    function resetVisibleUnitsOnscreen(option){

      $('ul#vi-banner-carousel').each(function(index,el){
        
        $('li').attr('data-visible-onviewport', false);

        if (option == -1){
          // console.log('resetVisibleUnitsOnscreen : prev');
          tempIndex --;
          slidesToShow --;
        }
        else if (option == 1){
          // console.log('resetVisibleUnitsOnscreen : next');
          tempIndex ++;
          slidesToShow ++;
        }
        else{
        }

        $(el).find('[data-activated-unit="true"]').slice( tempIndex, slidesToShow ).attr('data-visible-onviewport', true);
        // console.log('slice( tempIndex, slidesToShow ) ', tempIndex, slidesToShow);

      });

    };

    // detect last unit on screen & inject data attr
    function detectEndUnitOnViewport(){
      $('ul#vi-banner-carousel').each(function(index,el){
        $(el).find('li[data-end-unit-onviewport="true"]').attr('data-end-unit-onviewport', '');
        $(el).find('li[data-visible-onviewport="true"]').last().attr('data-end-unit-onviewport', true);
      });
    };

    function detectFirstUnitLastUnit(){
      $('ul#vi-banner-carousel').each(function(index,el){
        $(el).find('li[data-activated-unit="true"], li[data-first-end-unit="end"]').attr('data-first-end-unit', '');
        $(el).find('li[data-activated-unit="true"]').first().attr('data-first-end-unit', 'first');
        $(el).find('li[data-activated-unit="true"]').last().attr('data-first-end-unit', 'end');
      });
    };

    function excuteDisEnableArrowButtons(){
      $('ul#vi-banner-carousel a.slick-prev.slick-arrow, ul#vi-banner-carousel a.slick-next.slick-arrow').removeClass('disabled').addClass('enabled');

      if ( $('ul#vi-banner-carousel').find('[data-first-end-unit="first"][data-visible-onviewport="true"]').length ){
        $('ul#vi-banner-carousel a.slick-prev.slick-arrow').removeClass('enabled').addClass('disabled');
      }
      if ( $('ul#vi-banner-carousel').find('[data-first-end-unit="end"][data-visible-onviewport="true"][data-end-unit-onviewport="true"]').length ){
        $('ul#vi-banner-carousel a.slick-next.slick-arrow').removeClass('enabled').addClass('disabled');
      }
    };

    function changeAnimationSpeedOnToggleButton(){
      $('ul#vi-banner-carousel li.fit-unit').each(function(index){
        if (  $(this).attr('data-visible-onviewport') == "true" && $(this).attr('data-end-unit-onviewport') == "true" ||
              $(this).find('#end-fit-unit') == "true" ) {
          $(this).find('.expand-btn-fade').removeClass('expand-btn-fade').addClass('expand-btn-fade-last-child');
        }
        else{
          $(this).find('.expand-btn-fade-last-child').removeClass('expand-btn-fade-last-child').addClass('expand-btn-fade');
        }
      });
    };

    function detectDataAttrsToFixUnit(status, that){
      
      
      var $endFitUnitElement = $('li#end-fit-unit');
      var $endFitDetailsElement = $('li#end-fit-details');


      var statusEndFitUnit = $($endFitUnitElement).attr('data-first-end-unit'); 
      var isEndFitUnitVisibleOnviewport = $($endFitUnitElement).attr('data-visible-onviewport'); 
      var isEndFitUnitOnviewport = $($endFitUnitElement).attr('data-end-unit-onviewport'); 
      var isThisBtnEndFitUnit = that.closest('.fit-unit').is('#end-fit-unit');

      var statusEndFitDetails = $($endFitDetailsElement).attr('data-first-end-unit'); 
      var isEndFitDetailsVisibleOnviewport = $($endFitDetailsElement).attr('data-visible-onviewport');
      var isEndFitDetailsOnviewport = $($endFitDetailsElement).attr('data-end-unit-onviewport');


      if ( status === false && isThisBtnEndFitUnit == false && statusEndFitUnit == 'end' && isEndFitUnitVisibleOnviewport == 'true' && isEndFitUnitOnviewport == 'true' ) {
        // console.log('behavior 1');
        $("#vi-banner-carousel").slick('slickPrev');
        resetVisibleUnitsOnscreen(-1);
      }

      else if ( status === false && isThisBtnEndFitUnit == true && statusEndFitUnit == 'end' && isEndFitUnitVisibleOnviewport == 'true' && isEndFitUnitOnviewport == 'true' ){
        // console.log('behavior 2');
      }

      else if ( status === false && statusEndFitUnit == 'end' && isEndFitUnitVisibleOnviewport == 'true' && isEndFitUnitOnviewport == 'true') {
          // console.log('behavior 3');
          $("#vi-banner-carousel").slick('slickPrev');
          resetVisibleUnitsOnscreen(-1);
      }

      else if ( status === false && !isThisBtnEndFitUnit && statusEndFitDetails == 'end' && isEndFitUnitVisibleOnviewport == 'true' && isEndFitDetailsOnviewport == 'true') {
          // console.log('behavior 4');
          $("#vi-banner-carousel").slick('slickPrev');
          resetVisibleUnitsOnscreen(-1);
      }

      else if ( status === false && isThisBtnEndFitUnit && statusEndFitDetails == 'end' && isEndFitDetailsVisibleOnviewport == 'false' && isEndFitUnitVisibleOnviewport == 'true' && isEndFitUnitOnviewport == 'true') {
          // console.log('behavior 5');
      }
    
    }

    /**********************************
     3 fit view slider in fit unit
    ***********************************/

    $('.fit-unit .fit-image-wrapper').each(function(){
      $(this).find('alt-images-slider').clone().appendTo($(this));
    });

    $('li.fit-unit ul.alt-images-slider li:first-child').each(function(index){
      $(this).addClass('top'); 
    }); 

    // Excute the alt image slider
    var indexLoop = 0;
    var change = function (){
      
      if( altSlidesToShow <= indexLoop ) {
        indexLoop = 1;
      }
      else {
        indexLoop++;
      }

      $('li.fit-unit ul.alt-images-slider').each(function(index){
        
        if ( $(this).hasClass('active-alt-slider') ) {

         // console.log('indexLoop: ', indexLoop);
          var curr = $(this).find('li:nth-child('+ indexLoop +')');
          var next = curr.next('li'); 

          if(!next.length){
            next = $(this).find('li:first');
            next.addClass('top');
            curr.animate({opacity: 0},altSliderSpeed, function() {
              curr.removeClass('top');
              curr.css({opacity: 1});
            });
          }
          else{
            next.css({opacity: 0})
            .addClass('top')
            .animate({opacity: 1}, altSliderSpeed, function() {
              curr.removeClass('top');
            });
          }
        }
      });

    }


    function toggleButton_generateAltSlidesFunc(that) {
      if ( that.hasClass('expanded') ){

        var toCreateSlider = that.closest('span.expand-button-style').next();
        var fitUnitIndex = that.closest('li.fit-unit').attr('data-fit-unit-index');

        for ( i = 0 ; i < altSlidesToShow-1 ; i++){
          startNumber = i + 2;
          toCreateSlider.find('li:first').clone().appendTo(toCreateSlider).removeClass('default-alt-slide top').addClass('other-alt-slide alt-slide-style').children().attr('src', filenameByStyle[fitUnitIndex]+ startNumber + imageFileExtension);
          toCreateSlider.find('li:first').addClass('alt-slide-style');
        }

      }
      else{
        that.closest('span').next().removeClass('alt-slide-style').find('li.other-alt-slide').remove();
      }
      
      // add class to the active alt slider and the active slide
      that.closest('span').next().toggleClass('active-alt-slider');
    };


    /**********************************
     Toggle button function
    ***********************************/

    $('.image-map-bkgd').on('click', function(e) {
      var getParentsIndex = $(this).closest('li.fit-unit').attr('data-fit-unit-index');
      $('#toggle-point-' + getParentsIndex).trigger('click');

    });

    $('li.fit-details').on('click', function(e) {
      var getParentsIndex = $(this).prev().closest('li.fit-unit').attr('data-fit-unit-index');
      $('#toggle-point-' + getParentsIndex).trigger('click');

    });


    $('span.expand-button-style a').on('click', function(e) {

      var that = $(this);
      toggleButton_expandCollapseFunc(that);

      var buttonStatus = $(this).hasClass('expanded');

      var isThisLastUnit = $(this).closest('li.fit-unit').attr('data-end-unit-onviewport');
      var findSyncedDetailsOnviewport = $(this).closest('li.fit-unit').next().attr('data-end-unit-onviewport');
      var findSyncedDetailsOnslider = $(this).closest('li.fit-unit').next().attr('data-first-end-unit');

      if ( isThisLastUnit == "true" ) {
        if ( buttonStatus == false && $('#end-fit-details').attr('data-visible-onviewport') == "false" && $('#end-fit-unit').attr('data-visible-onviewport') ) {
        // do nothing
        }
        else{
          $("#vi-banner-carousel").slick('slickNext');
          resetVisibleUnitsOnscreen(1);
        }
        
      }

      else if( findSyncedDetailsOnviewport == "true" && findSyncedDetailsOnslider == "end") {
        $("#vi-banner-carousel").slick('slickPrev');
        resetVisibleUnitsOnscreen(-1);
      }

      else{
        resetVisibleUnitsOnscreen();
      }

      toggleButton_generateAltSlidesFunc(that);

      detectDataAttrsToFixUnit(buttonStatus, that);
      detectFirstUnitLastUnit();
      detectEndUnitOnViewport();
      excuteDisEnableArrowButtons();
      changeAnimationSpeedOnToggleButton();
      e.preventDefault();


      // send a status of alt views over to tracking func  
      if ( buttonStatus == true ) {
        var toggleStatusForTracking = '_click';
        // var toggleStatusForTracking = '_open';         
      }
      else{          
        var toggleStatusForTracking = '_click';
        // var toggleStatusForTracking = '_close';
      }  

    });


    /**********************************
      A Timer for alt slider
    ***********************************/
    //(This func must be placed here)
    
    $('span.expand-button-style a').click(function(){ 
      
        var interId = null;
        var i = 0;
        return function(e) {
         
          // Stop timer if active class exist
          if ( $(this).closest('ul').hasClass('active-alt-slider') ) {
            
            $(this).closest('ul').removeClass('active-alt-slider');
            $(this).closest('ul').find('li:first-child').addClass('top');

            $('ul.alt-images-slider').each(function(index){
              $active = $('.active-alt-slider').length;
              
              if ( $active > 0 ){
              }
              else{
                // console.log('timer stops');
                clearInterval(interId);
                interId = null;
                indexLoop = 0;
                return i = 0;
              }
            });
          }
          // Start timer if active class exist
          else{
            if ( i == 0 ){
              // console.log('timer starts');
              interId = setInterval(change, altSliderAutoplaySpeed );
            }
            i++;
            $(this).closest('ul').addClass('active-alt-slider');

          }
        };

    }());


    /**********************************
     Prev / Next button function
    ***********************************/

    $('a.slick-prev.slick-arrow').on('click', function(e) {
      resetVisibleUnitsOnscreen(-1);
      detectFirstUnitLastUnit();
      detectEndUnitOnViewport();
      excuteDisEnableArrowButtons();
      changeAnimationSpeedOnToggleButton();
      e.preventDefault();
    });

    $('a.slick-next.slick-arrow').on('click', function(e) {
      resetVisibleUnitsOnscreen(1);
      detectFirstUnitLastUnit();
      detectEndUnitOnViewport();
      excuteDisEnableArrowButtons();
      changeAnimationSpeedOnToggleButton();
      e.preventDefault();
    });

  });