/** global functions **/

function loadImgSeq(path, fileNamePrefix, fileExt, startFrom, endAt, fileCountPadding){
    images = [];
    for(i=startFrom; i<=endAt; i=i+1){
        img = new Image();
        img.src = path + fileNamePrefix + i.toString().padStart(fileCountPadding,"0") + fileExt;
        images.push(img);
    }

    return images;
}

function renderCanvas(canvas, image){
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
    canvas.getContext("2d").drawImage(image, 0, 0, canvas.width, canvas.height);
}

function renderCanvas_manualWidth(canvas, image, width, height){
    canvas.width = width;
    canvas.height = height;
    canvas.getContext("2d").drawImage(image, 0, 0, canvas.width, canvas.height);
}

/** global functions end **/



/** init controller **/
var controller = new ScrollMagic.Controller();



/** first section animation start **/

var product_rotation_images = loadImgSeq('images/gallery-spin/', 'frame-', '.jpg', 1, 85, 3);
product_rotation_images[0].onload = function(){renderCanvas($("#myimg2").get(0), this)}; //load first image on page load
var tween_val = { curImg: 0, textToShow:0 };
var tween2 = TweenMax.to(tween_val, 1, {
    curImg: product_rotation_images.length - 1,
    textToShow: $('#imagesequence2 .animHeading>span').length,
    roundProps: "curImg,textToShow",
    immediateRender: false,
    ease: Linear.easeInOut,
    onUpdate: function() {
        renderCanvas($("#myimg2").get(0), product_rotation_images[tween_val.curImg])
        $('#imagesequence2 .animHeading>span.show').removeClass('show')
        $('#imagesequence2 .animHeading>span:eq('+Math.min($('#imagesequence2 .animHeading>span').length-1,tween_val.textToShow)+')').addClass('show')
    }
});


// var product_zoom_images = loadImgSeq('images/hero-zoom/', 'zoom-', '.jpg', 1, 66, 0);
// var tween_val_zoom = { curImg: 0 };
// var tween2_zoom = TweenMax.to(tween_val_zoom, 1, {
//     curImg: product_zoom_images.length - 1,
//     roundProps: "curImg",
//     immediateRender: false,
//     ease: Linear.easeInOut,
//     onUpdate: function() {
//         renderCanvas($("#myimg2").get(0), product_zoom_images[tween_val_zoom.curImg])
//     }
// });



var product_fire_images = loadImgSeq('images/hero-fire/webp/', 'fire-', '.webp', 1, 84, 0);
var tween_val_fire = { curImg: 0 };
var tween3_zoom = TweenMax.to(tween_val_fire, 1, {
    curImg: product_fire_images.length - 1,
    roundProps: "curImg",
    immediateRender: false,
    ease: Linear.easeInOut,
    onUpdate: function() {
        renderCanvas($("#myimg2").get(0), product_fire_images[tween_val_fire.curImg])
    }
});


var firstTimeline = new TimelineMax();
firstTimeline.add(tween2,0);
// firstTimeline.add(tween2_zoom,1);
firstTimeline.add(tween3_zoom,1);

var childTimeline1 = new TimelineMax();
childTimeline1.fromTo("#imagesequence2 .animHeading",.1,{y: "0%", opacity:"1"},{y: "50%", opacity:"0", ease:Linear.easeOut},0.9)
childTimeline1.fromTo("#imagesequence2 .animfooter",.1,{y: "0%", opacity:"1"},{y: "-50%", opacity:"0", ease:Linear.easeOut},0.9)
childTimeline1.fromTo("#imagesequence2 .lastOverlay",.5,{opacity:"0"},{opacity:"1", ease:Linear.easeOut},1.5)
childTimeline1.fromTo("#imagesequence2 .lastOverlay h3",.2,{y: "300%",opacity:"0", scale:2},{y: "0%",opacity:"1", scale:1, ease:Linear.easeOut},1.9)
childTimeline1.fromTo("#imagesequence2 .lastOverlay h3",.1,{y: "0%"},{y: "0%", ease:Linear.easeOut, onStart:showBottomStack_flavour, onReverseComplete:hideBottomStack_flavour},2.2)
childTimeline1.fromTo("#imagesequence2 .lastOverlay h3",.1,{y: "0%"},{y: "0%", ease:Linear.easeOut, onStart:showBottomStack, onReverseComplete:hideBottomStack},2.4)

function showBottomStack(){
    $("#imagesequence2 .footerText .cont li").addClass('stackUp')
    $("#imagesequence2 .footerText .cont li").removeClass('stackDown')

    setTimeout(function(){
        $("#imagesequence2 .footerText .cont li").css({
            opacity: '1',
            transform: 'translateY(0px)'
        });
    },600);
}
function hideBottomStack(){
    $("#imagesequence2 .footerText .cont li").addClass('stackDown')
    $("#imagesequence2 .footerText .cont li").removeClass('stackUp')

    setTimeout(function(){
        $("#imagesequence2 .footerText .cont li").css({
            opacity: '0',
            transform: 'translateY(10px)'
        });
    },600);
}







function showBottomStack_flavour(){
    $("#imagesequence2 .op-box").addClass('stackUp')
    $("#imagesequence2 .op-box").removeClass('stackDown')

    setTimeout(function(){
        $("#imagesequence2 .op-box").css({
            opacity: '1',
            transform: 'translateY(0px)'
        });
    },600);
}
function hideBottomStack_flavour(){
    $("#imagesequence2 .op-box").addClass('stackDown')
    $("#imagesequence2 .op-box").removeClass('stackUp')

    setTimeout(function(){
        $("#imagesequence2 .op-box").css({
            opacity: '0',
            transform: 'translateY(10px)'
        });
    },600);
}







firstTimeline.add(childTimeline1,0);

var scene2 = new ScrollMagic.Scene({
    triggerElement: '#imagesequence2',
    duration: 8000,
    triggerHook: 0,
    reverse: true
})
.setPin('#imagesequence2')
.setTween(firstTimeline)
.addTo(controller);

/** first section animation end **/



/** video section animation start **/

var obj4 = { scrollTop: 0 };
var video_tween = TweenMax.to(obj4, 1, {
    scrollTop: $('#videoSection .overlayScroll').get(0).scrollHeight-$('#videoSection .overlayScroll').height(),
    roundProps: "scrollTop",
    delay: 0.05,
    ease: Linear.easeNone, // show every image the same ammount of time
    onUpdate: function() {
        $('#videoSection .overlayScroll').scrollTop(obj4.scrollTop)

        $('#videoSection .overlayScroll>span').each(function(index, el) {
          elemTop = $(el).position().top + $(el).outerHeight() - 10
          bottom = $('#videoSection .overlayScroll').height()

          if(elemTop < bottom){
            $(el).css("opacity",Math.min(1,Math.max(0,(bottom - elemTop)/100)))
          }else{
            $(el).css("opacity",0)
          }
        });
    }
});

var scene4 = new ScrollMagic.Scene({
    triggerElement: '#videoSection',
    triggerHook: 0,
    duration: 2000,
    reverse: true
})
.setPin('#videoSection')
.setTween(video_tween)
.addTo(controller);

/** video section animation end **/







 




 /******************* Start Third Section **********************///
var t5 = new TimelineMax();
  t5.fromTo(".blackbg", 2 ,{backgroundColor: '#000000'}, {backgroundColor: '#FFFFFF'});
  t5.fromTo(".t5sec", 2 ,{color: '#FFFFFF'}, {color: '#000000'},0);

var scene5 = new ScrollMagic.Scene({
    triggerElement: '.blackbg',
    triggerHook: 0,
    duration: 1000,
    reverse: true,

})
.setPin('.blackbg')
.setTween(t5)
.addTo(controller)
// .on("progress", function (event) {
//     //console.log(event.progress);
//        if(event.progress > 0.01){
//          $('.blackbg').css('opacity',1- event.progress)
//        }
//    })



/******************* End Third Section **********************///

/******************* Start 4th Section **********************///

/** video section animation start **/

var obj6 = { scrollTop: 0 };
var video_tween = TweenMax.to(obj6, 1, {
    scrollTop: $('#videoSection_two .overlayScroll').get(0).scrollHeight-$('#videoSection_two .overlayScroll').height(),
    roundProps: "scrollTop",
    delay: 0.05,
    ease: Linear.easeNone, // show every image the same ammount of time
    onUpdate: function() {
        $('#videoSection_two .overlayScroll').scrollTop(obj6.scrollTop)

        $('#videoSection_two .overlayScroll>span').each(function(index, el) {
          elemTop = $(el).position().top + $(el).outerHeight() - 10
          bottom = $('#videoSection_two .overlayScroll').height()

          if(elemTop < bottom){
            $(el).css("opacity",Math.min(1,Math.max(0,(bottom - elemTop)/100)))
          }else{
            $(el).css("opacity",0)
          }
        });
    }
});

var scene1 = new ScrollMagic.Scene({
    triggerElement: '#videoSection_two',
    triggerHook: 0,
    duration: 2000,
    reverse: true
})
.setPin('#videoSection_two')
.setTween(video_tween)
.addTo(controller);

/** video section animation end **/


/******************* End 4th Section **********************/// 

/******************* Start 5th Section **********************///

var t7 = new TimelineMax();
 t7.fromTo('.cta_btn_pro', 2 ,{autoAlpha:0}, {autoAlpha:1,onComplete:function(){$('.cta_btn_pro').css('opacity',1)}});
 //t7.fromTo('.cta_btn_pro', 2 ,{autoAlpha:1}, {autoAlpha:0});

 var scene7 = new ScrollMagic.Scene({
    triggerElement: '.cta_bg',
    triggerHook: 0,
    duration: 1000,
    reverse: true
})
.setPin('.cta_bg')
.setTween(t7)
.addTo(controller);



/******************* End 5th Section **********************///





// new section

var abcd = loadImgSeq('images/gallery-spin/', 'frame-', '.jpg', 1, 85, 3);
abcd[0].onload = function(){renderCanvas_manualWidth($("#abcd_canvas").get(0), this, 600, 400)};
var tween_val_abcd = { curImg: 0 };
var tween2_abcd = TweenMax.to(tween_val_abcd, 1, {
    curImg: abcd.length - 1,
    textScrollSpeed: 500,
    roundProps: "curImg, textScrollSpeed",
    immediateRender: false,
    ease: Linear.easeInOut,
    onUpdate: function() {
        if ($(window).width()>$(window).height()){
            renderCanvas_manualWidth($("#abcd_canvas").get(0), abcd[tween_val_abcd.curImg], 600, 400)
        }
        else{
            renderCanvas_manualWidth($("#abcd_canvas").get(0), abcd[tween_val_abcd.curImg], 300, 200)
        }
        $('#abcd .unmatched_content').css('transform',"translateY(-"+tween_val_abcd.textScrollSpeed+"px)")
    }
});
var scene_abcd = new ScrollMagic.Scene({
    triggerElement: '#abcd',
    triggerHook: 0,
    duration: 1500,
    reverse: true
})
.setPin('#abcd')
.setTween(tween2_abcd)
.addTo(controller);

// new section END


// new section

var stup = loadImgSeq('images/gallery-spin/', 'frame-', '.jpg', 1, 85, 3);
stup[0].onload = function(){renderCanvas_manualWidth($("#setup_canvas").get(0), this, 600, 400)};
var setup_val = { curImg: 0 };
var tween2_setup = TweenMax.to(setup_val, 1, {
    curImg: stup.length - 1,
    roundProps: "curImg",
    immediateRender: false,
    ease: Linear.easeInOut,
    onUpdate: function() {
        if ($(window).width()>$(window).height()){
            renderCanvas_manualWidth($("#setup_canvas").get(0), stup[setup_val.curImg], 600, 400)
        }
        else{
            renderCanvas_manualWidth($("#setup_canvas").get(0), stup[setup_val.curImg], 300, 200)
        }
    }
});
var scene_setup = new ScrollMagic.Scene({
    triggerElement: '#setup_area',
    triggerHook: 0,
    duration: 2000,
    reverse: true
})
.setPin('#setup_area')
.setTween(tween2_setup)
.addTo(controller);

// new section END




















/** Start Woodchip & Ript Left right animation ****/

var tb = new TimelineMax();

tb.fromTo(".box_anim_1", 1, {x:'-150%'}, {x:'0%',ease:Linear.easeInOut});
tb.fromTo(".box_anim_2", 1, {x:'150%'}, {x:'0%',ease:Linear.easeInOut},0);

var stb = new ScrollMagic.Scene({
    triggerElement: '.ttl_anim',
    triggerHook: 1,
    duration: 600,
    reverse: true
  })         
.setTween(tb)
.addTo(controller);

/** End Woodchip & Ript Left right animation ****/


/** Start Set up Combination animation ****/

 var scb = new TimelineMax();

scb.fromTo(".access-1", 1, {opacity:0}, {opacity:1,ease:Linear.easeInOut});
scb.fromTo(".access-2", 2, {opacity:0}, {opacity:1,ease:Linear.easeInOut},1);

var stb = new ScrollMagic.Scene({
    triggerElement: '.setup_area',
    triggerHook: 0,
    duration: 1200,
    reverse: true
  })
.setPin('.setup_area')             
.setTween(scb)
.addTo(controller);

/** End Set up Combination  animation ****/








