/** global functions **/

function loadImgSeq_lander(path, fileNamePrefix, fileExt, startFrom, endAt, fileCountPadding) {

    images = [];

    for (i = startFrom; i <= endAt; i = i + 1) {

        img = new Image();

        img.src = path + fileNamePrefix + i.toString().padStart(fileCountPadding, "0") + fileExt;

        images.push(img);

    }

    return images;

}



function Simplelander_manualWidth(canvas, image, width, height) {

    canvas.width = width;

    canvas.height = height;

    canvas.getContext("2d").drawImage(image, 0, 0, canvas.width, canvas.height);

}



/** global functions end **/









/** init controller common section Start **/

var controller = new ScrollMagic.Controller();

/** init controller common section End **/







// new section

var startup_simple_lander = loadImgSeq_lander('images/gallery-spin/', 'frame-', '.jpg', 1, 85, 3);

startup_simple_lander[0].onload = function() { Simplelander_manualWidth($("#simpleLanderCanvas").get(0), this, 400, 250) };

var setup_val_simpleLander = { curImg_lander: 0, textToShow:0 };

var tween_setup_SimpleLander = TweenMax.to(setup_val_simpleLander, 1, {

    curImg_lander: startup_simple_lander.length + 10,

    roundProps: "curImg_lander,textToShow",

    textToShow: $('#Lander_Scrollsequence_Section .head_animation_txt>ul>li').length,

    immediateRender: false,

    ease: Linear.easeInOut,

    onUpdate: function() {

        Simplelander_manualWidth($("#simpleLanderCanvas").get(0), startup_simple_lander[Math.min(setup_val_simpleLander.curImg_lander,startup_simple_lander.length - 1)], 400, 250);

        $('#Lander_Scrollsequence_Section .head_animation_txt>ul>li.show').removeClass('show')

        $('#Lander_Scrollsequence_Section .head_animation_txt>ul>li:eq('+Math.min($('#Lander_Scrollsequence_Section .head_animation_txt>ul>li').length-1,setup_val_simpleLander.textToShow)+')').addClass('show')

    }

});




// Start Why wood Section Scroll ///


var why_wood_section= loadImgSeq_lander('images/gallery-spin/', 'frame-', '.jpg', 1, 6, 3);

why_wood_section[0].onload = function() { Simplelander_manualWidth($("#whyWoodSecCanvas").get(0), this, 500, 334) };

var setup_val_why_wood_section= { currentWoodImg: 0 , bulletActive:0};

var tween_why_wood_section = TweenMax.to(setup_val_why_wood_section, 0.3, {

    currentWoodImg: why_wood_section.length - 1,
  
    bulletActive: $('#left_woodarea_why ul>li').length - 1,
  
    roundProps: "currentWoodImg,bulletActive",
  
    immediateRender: false,
  
    ease: Linear.easeInOut,

    onUpdate: function() {

        Simplelander_manualWidth($("#whyWoodSecCanvas").get(0), why_wood_section[setup_val_why_wood_section.currentWoodImg], 500, 334);

        $('#left_woodarea_why ul>li.boldfnt').removeClass('boldfnt')

        $('#left_woodarea_why ul>li:eq('+Math.min($('#left_woodarea_why ul>li').length-1,setup_val_why_wood_section.bulletActive)+')').addClass('boldfnt')
       
    }

});


// End Why wood Section Scroll ///

var scene_setup_simpleLander = new ScrollMagic.Scene({

        triggerElement: '#Lander_Scrollsequence_Section',

        triggerHook: 0,

        duration: 2000,

        reverse: true

    })

    .setPin('#Lander_Scrollsequence_Section')

    .setTween(tween_setup_SimpleLander)

    .addTo(controller);
    


// new section END



var tween_setup_whynow = new TimelineMax();

tween_setup_whynow.fromTo("#whynow .footer_image_btm_image",4,{bottom: "100%"},{bottom: "0%", ease:Linear.easeOut},0)

tween_setup_whynow.fromTo("#whynow .big_ript_logo_white",1,{top: "-20%", y:"-100%"},{top: "32%", y:"0%", ease:Linear.easeOut},4)

tween_setup_whynow.fromTo("#whynow h4,#whynow .black_desc,#whynow .black_area_btn",3,{opacity:"0"},{opacity: "2", ease:Linear.easeOut},5.5)



var scene_setup_why_now = new ScrollMagic.Scene({

        triggerElement: '#whynow',

        triggerHook: 0,

        duration: 3000,

        reverse: true

    })

    .setPin('#whynow')

    .setTween(tween_setup_whynow)

    .addTo(controller);






// new section


var why_wood = new ScrollMagic.Scene({

        triggerElement: '#why_wood_sec',

        triggerHook: 0,

        duration: 2000,

        reverse: true

    })

    .setPin('#why_wood_sec')
    .setTween(tween_why_wood_section)
    .addTo(controller);

// new section END


