/** global functions **/

function loadImgSeq(path, fileNamePrefix, fileExt, startFrom, endAt, fileCountPadding){
    images = [];
    for(i=startFrom; i<=endAt; i=i+1){
        img = new Image();
        img.src = path + fileNamePrefix + i.toString().padStart(fileCountPadding,"0") + fileExt;
        images.push(img);
    }

    return images;
}

function renderCanvas(canvas, image){
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
    canvas.getContext("2d").drawImage(image, 0, 0, canvas.width, canvas.height);
}

/** global functions end **/



/** init controller **/
var controller = new ScrollMagic.Controller();



/** first section animation start **/

var product_rotation_images = loadImgSeq('images/gallery-spin/', 'frame-', '.jpg', 1, 85, 3);
product_rotation_images[0].onload = function(){renderCanvas($("#myimg2").get(0), this)}; //load first image on page load
var tween_val = { curImg: 0, textToShow:0 };
var tween2 = TweenMax.to(tween_val, 1, {
    curImg: product_rotation_images.length - 1,
    textToShow: $('#imagesequence2 .animHeading>span').length,
    roundProps: "curImg,textToShow",
    immediateRender: false,
    ease: Linear.easeInOut,
    onUpdate: function() {
        renderCanvas($("#myimg2").get(0), product_rotation_images[tween_val.curImg])
        $('#imagesequence2 .animHeading>span.show').removeClass('show')
        $('#imagesequence2 .animHeading>span:eq('+Math.min($('#imagesequence2 .animHeading>span').length-1,tween_val.textToShow)+')').addClass('show')
    }
});


var product_zoom_images = loadImgSeq('images/hero-fire/webp/', 'fire-', '.webp', 1, 84, 0);
var tween_val_zoom = { curImg: 0 };
var tween2_zoom = TweenMax.to(tween_val_zoom, 1, {
    curImg: product_zoom_images.length - 1,
    roundProps: "curImg",
    immediateRender: false,
    ease: Linear.easeInOut,
    onUpdate: function() {
        renderCanvas($("#myimg2").get(0), product_zoom_images[tween_val_zoom.curImg])
    }
});





var firstTimeline = new TimelineMax();
firstTimeline.add(tween2,0);
firstTimeline.add(tween2_zoom,1);


var childTimeline1 = new TimelineMax();
childTimeline1.fromTo("#imagesequence2 .animHeading",.1,{y: "0%", opacity:"1"},{y: "50%", opacity:"0", ease:Linear.easeOut},0.9)
childTimeline1.fromTo("#imagesequence2 .animfooter",.1,{y: "0%", opacity:"1"},{y: "-50%", opacity:"0", ease:Linear.easeOut},0.9)
// childTimeline1.fromTo("#imagesequence2 .lastOverlay",.5,{opacity:"0"},{opacity:"1", ease:Linear.easeOut},3)
// childTimeline1.fromTo("#imagesequence2 .lastOverlay h1",.2,{y: "300%",opacity:"0", scale:2},{y: "0%",opacity:"1", scale:1, ease:Linear.easeOut},3.2)
// childTimeline1.fromTo("#imagesequence2 .lastOverlay h1",.1,{y: "0%"},{y: "0%", ease:Linear.easeOut, onStart:showBottomStack, onReverseComplete:hideBottomStack},3.6)

function showBottomStack(){
    $("#imagesequence2 .footerText .cont>span").addClass('stackUp')
    $("#imagesequence2 .footerText .cont>span").removeClass('stackDown')

    setTimeout(function(){
        $("#imagesequence2 .footerText .cont>span").css({
            opacity: '1',
            transform: 'translateY(0px)'
        });
    },600);
}
function hideBottomStack(){
    $("#imagesequence2 .footerText .cont>span").addClass('stackDown')
    $("#imagesequence2 .footerText .cont>span").removeClass('stackUp')

    setTimeout(function(){
        $("#imagesequence2 .footerText .cont>span").css({
            opacity: '0',
            transform: 'translateY(10px)'
        });
    },600);
}


firstTimeline.add(childTimeline1,0);

var scene2 = new ScrollMagic.Scene({
    triggerElement: '#imagesequence2',
    duration: 9000,
    triggerHook: 0,
    reverse: true
})
.setPin('#imagesequence2')
.setTween(firstTimeline)
.addTo(controller);

/** first section animation end **/




/** video section animation start **/

var obj4 = { scrollTop: 0 };
var video_tween = TweenMax.to(obj4, 1, {
    scrollTop: $('#videoSection .overlayScroll').get(0).scrollHeight-$('#videoSection .overlayScroll').height(),
    roundProps: "scrollTop",
    delay: 0.05,
    ease: Linear.easeNone, // show every image the same ammount of time
    onUpdate: function() {
        $('#videoSection .overlayScroll').scrollTop(obj4.scrollTop)

        $('#videoSection .overlayScroll>span').each(function(index, el) {
          elemTop = $(el).position().top + $(el).outerHeight() - 10
          bottom = $('#videoSection .overlayScroll').height()

          if(elemTop < bottom){
            $(el).css("opacity",Math.min(1,Math.max(0,(bottom - elemTop)/100)))
          }else{
            $(el).css("opacity",0)
          }
        });
    }
});

var scene4 = new ScrollMagic.Scene({
    triggerElement: '#videoSection',
    triggerHook: 0,
    duration: 2000,
    reverse: true
})
.setPin('#videoSection')
.setTween(video_tween)
.addTo(controller);
scene4.on("enter", function (event) { 
    $('#vid-sec').get(0).pause();
 })

scene4.on("leave", function (event) {
    $('#vid-sec').get(0).play();
 })
/** video section animation end **/
 
 /******************* Start Third Section **********************///
var t5 = new TimelineMax();
  t5.fromTo(".blackbg", 2 ,{backgroundColor: '#000000'}, {backgroundColor: '#FFFFFF'});
  t5.fromTo(".t5sec", 2 ,{color: '#FFFFFF'}, {color: '#000000'},0);

var scene5 = new ScrollMagic.Scene({
    triggerElement: '.blackbg',
    triggerHook: 0,
    duration: 1000,
    reverse: true,

})
.setPin('.blackbg')
.setTween(t5)
.addTo(controller)
// .on("progress", function (event) {
//     //console.log(event.progress);
//        if(event.progress > 0.01){
//          $('.blackbg').css('opacity',1- event.progress)
//        }
//    })



/******************* End Third Section **********************///

/******************* Start 4th Section **********************///
var t6 = new TimelineMax();
 t6.fromTo('.tast_df', 2 ,{autoAlpha:0}, {autoAlpha:1,onComplete:function(){$('.tast_df').css('opacity',1)}});
 //t6.fromTo('.tast_df', 2 ,{autoAlpha:1}, {autoAlpha:0});

 var scene6 = new ScrollMagic.Scene({
    triggerElement: '#videoSection_two',
    triggerHook: 0,
    duration: 1000,
    reverse: true
})
.setPin('#videoSection_two')
.setTween(t6)
.addTo(controller);

scene6.on("enter", function (event) { 
    $('#vid-sec-two').get(0).play();
 })

scene6.on("leave", function (event) {
    $('#vid-sec-two').get(0).pause();
 })



/******************* End 4th Section **********************/// 

/******************* Start 5th Section **********************///

var t7 = new TimelineMax();
 t7.fromTo('.cta_btn_pro', 2 ,{autoAlpha:0}, {autoAlpha:1,onComplete:function(){$('.cta_btn_pro').css('opacity',1)}});
 //t7.fromTo('.cta_btn_pro', 2 ,{autoAlpha:1}, {autoAlpha:0});

 var scene7 = new ScrollMagic.Scene({
    triggerElement: '.cta_bg',
    triggerHook: 0,
    duration: 1000,
    reverse: true
})
.setPin('.cta_bg')
.setTween(t7)
.addTo(controller);



/******************* End 5th Section **********************///
