﻿
jQuery(document).ready(function ($) {
    $('[data-popup-target]').click(function () {
        $('body').addClass('modal-open-pop');
        var activePopup = $(this).attr('data-popup-target');        
        $(activePopup).addClass('visible');
        sessionStorage.setItem("activePopup",activePopup ); 
    });
    $(document).keyup(function (e) {
        if (e.keyCode == 27 && $('body').hasClass('modal-open-pop')) {
            clearPopup();
        }
    });
    $('.popup-exit').click(function () {
        clearPopup();
    });
    $('.popup-overlay').click(function () {
        clearPopup();
    });   
    window.onclick = function(event) {
        var activePopup = sessionStorage.getItem("activePopup");
        newStr = activePopup.replace(/#/g, '');
        var ebModal = document.getElementById(newStr);  
        if (event.target == ebModal) {
            clearPopup();
        }
    }
    function clearPopup() {
        $('.popup.visible').addClass('transitioning').removeClass('visible');
        $('body').removeClass('modal-open-pop');
        
        setTimeout(function () {
            $('.popup').removeClass('transitioning');
            sessionStorage.removeItem("activePopup");
        }, 200);      
    }
});



