// buttons initialization
let playButton = document.getElementById("playButton");
let stopButton = document.getElementById("stopButton");
// audio source getting
let audio = document.getElementById("audio");
// duration line of a composition
let duration = document.getElementById('duration').childNodes[0].style;


let loop = function(){
    if(!audio.paused){
      window.requestAnimationFrame(loop);
    }
  // current position on sound 
   duration.width = Math.round (+audio.currentTime*100 / (+audio.duration))+"px";
 
}

// play button click
playButton.onclick = function(){
  
    if(audio.paused){
        audio.play();
        playButton.classList.remove('play');
        playButton.classList.add('pause');
      
      loop();
    }else{
        audio.pause();
        playButton.classList.remove('pause');
        playButton.classList.add('play');

    }
}


// stop button click
stopButton.onclick = function(){
  audio.pause();
  audio.currentTime = 0;
  duration.width = 0;
  playButton.classList.remove('pause');
  playButton.classList.add('play');
}